/******************************************************************************
 CCodeSection.c

				CCodeSection ArrayPane Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 8:52 PM Mon, Sep 27, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.

	If you change the name of the document class, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CCodeSection.h"
#include <string.h>

/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICCodeSection

	Initialize the object

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void	CCodeSection::ICCodeSection(
	CView			*anEnclosure,
	CBureaucrat		*aSupervisor,
	short			aWidth,
	short			aHeight,
	short			aHEncl,
	short			aVEncl,
	SizingOption	aHSizing,
	SizingOption	aVSizing)
{
	x_CCodeSection::Ix_CCodeSection(anEnclosure, aSupervisor,
					aWidth, aHeight, aHEncl, aVEncl, aHSizing, aVSizing);

		// Initialize your own data members below
	units = NULL;
	unit_count = 0;
	col[0] = indent.h;
	col[1] = col[0] + 40;
	col[2] = col[1] + 40;
	col[3] = col[2] + 40;
}

/******************************************************************************
 SetLibUnits

        
 ******************************************************************************/

void	CCodeSection::SetLibUnits(int count, LibUnit *u)
{
	unit_count = count;
	units = u;
}

/******************************************************************************
 DrawCell
 
 	Draw a single cell. The default is text call GetCellText and then
 	draw that text. If your table is textual you could just override
 	GetCellText. If the cells don't have text, or have text plus other
 	graphics, then override DrawCell.
 	cellRect is already translated from long to QD coordinates.
******************************************************************************/

void CCodeSection::DrawCell( Cell theCell, Rect *cellRect)
{
	
	if (theCell.v > unit_count)
		inherited::DrawCell(theCell, cellRect);

	else {
		register char *a;
		
		MoveTo( cellRect->left + col[0], cellRect->top + indent.v);
		a = units[theCell.v].comp_status ? "active" : "obsolete";
		DrawText(a, 0, strlen(a));
		
		MoveTo( cellRect->left + col[1], cellRect->top + indent.v);
		if (units[theCell.v].is_main) {
			if (strncmp("ma", unit_name_type(units[theCell.v].uname), 2))
				a = "(Interface)";
			else
				a = "(Main)";
		}
		else
			a = "";

		DrawText(a, 0, strlen(a));
		
		MoveTo( cellRect->left + col[2], cellRect->top + indent.v);
		a = units[theCell.v].comp_date;
		DrawText(a, 0, strlen(a));
		
		MoveTo( cellRect->left + col[3], cellRect->top + indent.v);
		a = units[theCell.v].uname;
		DrawText(a, 0, strlen(a));


	}

}	/* CCodeSection::DrawCell */


